/*
Das 2.1 Programm
17.10.2020 www.satyria.de
*/

.include "base.inc"

.section .init
.globl _start
_start:

b main

.section .text    @Anweisung an den Linker, dass jetzt Code kommt

main:             @Erzeuge das Label "main"
   mov sp,#0x8000 @Erzeuge einen Stapel von 32768 Bytes

@NEW
/*
* LED is Pin42
* on the GPFSEL4 register Bits 8-6
* 001 = GPIO Pin 42 is an output
*/

   mov r1,#1
   lsl r1,#6  /* -> 001 000 000 */

/*
* 0x10 GPFSEL4 GPIO Function Select 4
*/
 
   ldr r0,=GPFSEL4
   str r1,[r0]

/* 
* Set the 42 Bit
* 25:0 SETn (n=32..57) 0 = No effect; 1 = Set GPIO pin n.
* 42 - 32 = 10
*/

   mov r1,#1
   lsl r1,#10

MainLoop:         @Endlosschleife 

/*
* 0x2C GPCLR1 GPIO Pin Output Clear 1 
*/

   ldr r0,=GPCLR1 @LED ist aus
   str r1,[r0]

/* 
* Waiting
*/

   mov r2,#0x3F0000
wait1$:
   sub r2,#1
   cmp r2,#0
   bne wait1$

/*
* 0x20 GPSET1 GPIO Pin Output Set 1 
*/

   ldr r0,=GPSET1 @LED ist an
   str r1,[r0]

/* 
* Waiting
*/

   mov r2,#0x3F0000
wait2$:
	sub r2,#1
	cmp r2,#0
	bne wait2$

   b MainLoop
  