/* void UartInit (void)
   Initialisierung des UART-Ports
*/
UartInit:
   push {r1,lr}

   ldr r0,=UART0_LINE_CTRL       @Line_CTRL
   mov r1,#0                     @Alles auf NULL
   str r1,[r0]                   @und speichern

   ldr r0,=UART0_CONTROL         @CONTROL
   mov r1,#0                     @Alles auf NULL
   str r1,[r0]                   @und speichern

/* GPIO 14 und 15 */

   mov r0,#14							@TXD0
   mov r1,#GPIO_alt0             @ALT 0
   bl SetGPIOFunction
   
   mov r0,#15							@RXD0
   mov r1,#GPIO_alt0             @ALT 0
   bl SetGPIOFunction
   
   ldr r0,=GPPUD
   mov r1,#GPPUD_OFF
   str r1,[r0]
   
   mov r0,#MICROS_PER_MILLISECOND
   bl wait

   ldr r0,=GPPUDCLK0
   mov r1,#0b11                  @zwei Pins
   lsl r1,#14                    @Ab Bit 14
   str r1,[r0]

   ldr r0,=UART0_IBRD
   mov r1,#26
   str r1,[r0]

   ldr r0,=UART0_FBRD
   mov r1,#3
   str r1,[r0]

   ldr r0,=UART0_LINE_CTRL
   mov r1,#BYTE_WORD_LENGTH | ENABLE_FIFO
   str r1,[r0]

   ldr r0,=UART0_CONTROL
   mov r1,#ENABLE | TX_ENABLE | RX_ENABLE
   str r1,[r0]

	pop {r1,pc}

/* void UartPutc (int Char)
   Schreibe Zeichen in den UART
*/
UartPutc:                           
   push {r1,r2,lr}
   mov r2,r0                     @sichere Char

   UartPutc_loop1$:              @Warte, bis UART leer ist...
      ldr r0,=UART0_STATUS       @Adresse UART0_STATUS 
      ldr r1,[r0]                @Lade Status nach r4
      ands r1,r1,#TX_FIFO_FULL   @Wenn Status voll ist
      bne UartPutc_loop1$        @Warte weiter

   ldr r0,=UART0_DATA            @Adresse für Daten
   strb r2,[r0]                  @Schreibe Char in den Datenkanal
    
	pop {r1,r2,pc}      @Ende der Funktion
  

/* void UartPuts (int String, int len)
   schreibe String in der Länge (len) zum UART
   
*/

UartPuts:
   push {r1,r2,lr}
   mov r2,r0                  @Sichere Adresse des Strings

   UartPuts_loop1:
      subs r1,#1              @Länge um 1 reduzieren
      blt UartPuts_loopend    @Sobald Länge Null ist Springe
      ldrb r0,[r2]            @Lade Char aus String nach r0
      add r2,#1               @Zeiger des Strings um 1 erhöhen
      bl UartPutc             @Zeige Char an
	  b UartPuts_loop1         @Nächstes Zeichen anzeigen
   UartPuts_loopend:
   
   mov r0,#'\n'               @Neue Zeile
   bl UartPutc                @Übergeben und anzeigen
   
   mov r0,#'\r'               @In Zeile zurück gehen
   bl UartPutc                @und übertragen
   
   pop {r1,r2,pc}
   
/* char UartGetc (void)
   Hole Char aus UART */
UartGetc:
   push {r4,lr}

   UartGetc_loop1$:              @Warte, bis UART leer ist...
      ldr r0,=UART0_STATUS       @Adresse UART0_STATUS 
      ldr r1,[r0]                @Lade Status nach r4
      ands r1,r1,#RX_FIFO_EMPTY   @Wenn Status voll ist
      bne UartGetc_loop1$        @Warte weiter

   ldr r0,=UART0_DATA            @Adresse für Daten
   ldrb r0,[r0]                  @Schreibe Char nach r0
   mov r4,r0
   bl UartPutc
   mov r0,r4
   pop {r4,pc}
   
UartGetLine:
   push {r4,r5,lr}
   mov r0,#'>'               
   bl UartPutc 
   
   mov r4,#0
   ldr r5,=Eingabe
 UartGetLineLoop:  
   bl UartGetc
   cmp	r0, #13
   beq UartGetLineEnd
   strb r0,[r5]
   add r5,#1
   add r4,#1
   b UartGetLineLoop
   
   
UartGetLineEnd:
   mov r0,#'\n'               @Neue Zeile
   bl UartPutc                @Übergeben und anzeigen
   
   mov r0,#'\r'               @In Zeile zurück gehen
   bl UartPutc                @und übertragen
   
   ldr r0,=EingabeLen
   str r4,[r0]
   
   pop {r4,r5,pc}
   
.section .data

GetLineStruct:
   EingabeLen:
      .int 0
   Eingabe:
      .space 256

.section .text   
   
   
   