/* Raspberry PI 4 Deklarationen
*  Datei: base.inc
*  Erstellt: 17.10.2020
*/

.equ RPI_BASE, 0xFE000000 

.equ GPIO_BASE, RPI_BASE + 0x200000

@ GPIO function select (GFSEL) registers have 3 bits per GPIO
.equ GPFSEL0, GPIO_BASE + 0x0   @GPIO select 0
.equ GPFSEL1, GPIO_BASE + 0x4   @GPIO select 1
.equ GPFSEL2, GPIO_BASE + 0x8   @GPIO select 2
.equ GPFSEL3, GPIO_BASE + 0xC   @GPIO select 3
.equ GPFSEL4, GPIO_BASE + 0x10  @GPIO select 4

   .equ GPIO_input,  0b000      @Input
   .equ GPIO_output, 0b001      @Output
   .equ GPIO_alt0,   0b100      @alternate function 0
   .equ GPIO_alt1,   0b101      @alternate function 1
   .equ GPIO_alt2,   0b110      @alternate function 2
   .equ GPIO_alt3,   0b111      @alternate function 3
   .equ GPIO_alt4,   0b011      @alternate function 4
   .equ GPIO_alt5,   0b010      @alternate function 5

@GPIO SET/CLEAR registers have 1 bit per GPIO
.equ GPSET0, GPIO_BASE + 0x1C @set0 (GPIO 0 - 31)
.equ GPSET1, GPIO_BASE + 0x20 @set1 (GPIO 32 - 63)
.equ GPCLR0, GPIO_BASE + 0x28 @clear0 (GPIO 0 - 31)
.equ GPCLR1, GPIO_BASE + 0x2C @clear1 (GPIO 32 - 63)

@Alte GPIO-Funktionen
.equ GPPUD,     GPIO_BASE + 0x94        
    .equ   GPPUD_OFF,       0b00
.equ GPPUDCLK0, GPIO_BASE + 0x98


@Timer registers
.equ TIMER_BASE, RPI_BASE + 0x003000
.equ TIMER_CS, TIMER_BASE + 0x00 @clock status
.equ TIMER_CLO, TIMER_BASE + 0x04 @ clock low 32 bytes
.equ TIMER_CHI, TIMER_BASE + 0x08 @ clock high 32 bytes

.equ MICROS_PER_SECOND, 1000000 @ Microseconds per second
.equ MICROS_PER_MILLISECOND, 1000 @ Microseconds per millisecond

.equ T1_CLOCK_SECOND, MICROS_PER_SECOND @ RPi is microseconds

@UART0
.equ UART0_BASE, RPI_BASE + 0x201000    @Basisadresse UART0
.equ UART0_DATA,      UART0_BASE + 0x00 @DR Data Register 
.equ UART0_RSRECR,    UART0_BASE + 0x04 @RSRECR
.equ UART0_STATUS,     UART0_BASE + 0x18 @FR Flag Register
	.equ TX_FIFO_FULL, 		0b100000
   .equ RX_FIFO_EMPTY,     0b10000
.equ UART0_ILPR,      UART0_BASE + 0x20 @ILPR not in use
.equ UART0_IBRD,      UART0_BASE + 0x24 @IBRD Integer Baud rate divisor
.equ UART0_FBRD,      UART0_BASE + 0x28 @FBRD Feactional Baud rate divisor
.equ UART0_LINE_CTRL, UART0_BASE + 0x2C @LCRH Line Control register
	.equ ENABLE_FIFO, 		0b10000
	.equ BYTE_WORD_LENGTH, 	0b1100000
.equ UART0_CONTROL,   UART0_BASE + 0x30 @CR Control register
	.equ ENABLE, 			0b1
	.equ TX_ENABLE, 		0b100000000
	.equ RX_ENABLE, 		0b1000000000
.equ UART0_IFLS,      UART0_BASE + 0x34 @IFLS Interrupt FIFO Level Select Register 
.equ UART0_IMSC,      UART0_BASE + 0x38 @IMSC Interrupt Mask Set Clear Register
.equ UART0_RIS,       UART0_BASE + 0x3C @RIS Raw Interrupt Status Register
.equ UART0_MIS,       UART0_BASE + 0x40 @MIS Masked Interrupt Status Register
.equ UART0_ICR,       UART0_BASE + 0x44 @ICR Interrupt Clear Register
.equ UART0_DMACR,     UART0_BASE + 0x48 @DMACR DMA Control register
.equ UART0_ITCR,      UART0_BASE + 0x80 @ITCR Test Control register
.equ UART0_ITIP,      UART0_BASE + 0x84 @ITIP Integration test input reg
.equ UART0_ITOP,      UART0_BASE + 0x88 @ITOP Integration test output reg
.equ UART0_TDR,       UART0_BASE + 0x8C @TDR Test Data reg

@Mailbox
.equ MAILBOX_BASE, RPI_BASE + 0xB880 
.equ MAIL_WRITE, MAILBOX_BASE + 0x20
.equ MAIL_TAG_WRITE, MAIL_WRITE + 0x8

@Mailbox Tags
   @VideoCore
      .equ Get_firmware_revision, 0x00000001
   @Hardware
      .equ Get_board_model, 0x00010001
      .equ Get_board_revision, 0x00010002
      .equ Get_board_MAC_address, 0x00010003
      .equ Get_board_serial, 0x00010004
      .equ Get_ARM_memory, 0x00010005
      .equ Get_VC_memory, 0x00010006
      .equ Get_clocks, 0x00010007
   @Config
      .equ Get_command_line, 0x00050001
   @Shared resource management
      .equ Get_DMA_channels, 0x00060001
   @Power
      .equ Device_ID_SD_Card, 0x00000000
      .equ Device_ID_UART0, 0x00000001
      .equ Device_ID_UART1, 0x00000002
      .equ Device_ID_USB_HCD, 0x00000003
      .equ Device_ID_I2C0, 0x00000004
      .equ Device_ID_I2C1, 0x00000005
      .equ Device_ID_I2C2, 0x00000006
      .equ Device_ID_SPI, 0x00000007
      .equ Device_ID_CCP2TX, 0x00000008
      .equ Device_ID_xyz1, 0x00000009 @Unknown (RPi4)
      .equ Device_ID_xyz2, 0x0000000a @Unknown (RPi4)
      
      .equ Get_power_state, 0x00020001
      .equ Get_timing, 0x00020002
      .equ Set_power_state, 0x00028001
   @Clocks
      .equ Clock_ID_reserved, 0x000000000
      .equ Clock_ID_EMMC, 0x000000001
      .equ Clock_ID_UART, 0x000000002
      .equ Clock_ID_ARM, 0x000000003
      .equ Clock_ID_CORE, 0x000000004
      .equ Clock_ID_V3D, 0x000000005
      .equ Clock_ID_H264, 0x000000006
      .equ Clock_ID_ISP, 0x000000007
      .equ Clock_ID_SDRAM, 0x000000008
      .equ Clock_ID_PIXEL, 0x000000009
      .equ Clock_ID_PWM, 0x00000000a
      .equ Clock_ID_HEVC, 0x00000000b
      .equ Clock_ID_EMMC2, 0x00000000c
      .equ Clock_ID_M2MC, 0x00000000d
      .equ Clock_ID_PIXEL_BVB, 0x00000000e

      .equ Get_clock_state, 0x00030001
      .equ Set_clock_state, 0x00038001
      .equ Get_clock_rate, 0x00030002
      .equ Set_clock_rate, 0x00038002
      .equ Get_max_clock_rate, 0x00030004
      .equ Get_min_clock_rate, 0x00030007
      .equ Get_turbo, 0x00030009
      .equ Set_turbo, 0x00038009
   @Voltage
      .equ Voltage_ID_reserved, 0x000000000
      .equ Voltage_ID_Core, 0x000000001
      .equ Voltage_ID_SDRAM_C, 0x000000002
      .equ Voltage_ID_SDRAM_P, 0x000000003
      .equ Voltage_ID_SDRAM_I, 0x000000004

      .equ Get_voltage, 0x00030003
      .equ Set_voltage, 0x00038003
      .equ Get_max_voltage, 0x00030005
      .equ Get_min_voltage, 0x00030008
      .equ Get_temperature, 0x00030006
      .equ Get_max_temperature, 0x0003000a
      .equ Allocate_Memory, 0x0003000c
      .equ Lock_memory, 0x0003000d
      .equ Unlock_memory, 0x0003000e
      .equ Release_Memory, 0x0003000f
      .equ Execute_Code, 0x00030010
      .equ Get_Dispmanx_Resource_mem_handle, 0x00030014
      .equ Get_EDID_block, 0x00030020
   @Frame Buffer
      .equ Allocate_buffer, 0x00040001
      .equ Release_buffer, 0x00048001
      .equ Blank_screen, 0x00040002
      .equ Get_physical_display, 0x00040003
      .equ Test_physical_display, 0x00044003
      .equ Set_physical_display, 0x00048003
      .equ Get_virtual_buffer, 0x00040004
      .equ Test_virtual_buffer, 0x00044004
      .equ Set_virtual_buffer, 0x00048004
      .equ Get_depth, 0x00040005
      .equ Test_depth, 0x00044005
      .equ Set_depth, 0x00048005
      .equ Get_pixel_order, 0x00040006
      .equ Test_pixel_order, 0x00044006
      .equ Set_pixel_order, 0x00048006
      .equ Get_alpha_mode, 0x00040007
      .equ Test_alpha_mode, 0x00044007
      .equ Set_alpha_mode, 0x00048007
      .equ Get_pitch, 0x00040008
      .equ Get_virtual_offset, 0x00040009
      .equ Test_virtual_offset, 0x00044009
      .equ Set_virtual_offset, 0x00048009
      .equ Get_overscan, 0x0004000a
      .equ Test_overscan, 0x0004400a
      .equ Set_overscan, 0x0004800a
      .equ Get_palette, 0x0004000b
      .equ Test_palette, 0x0004400b
      .equ Set_palette, 0x0004800b
      .equ Set_Cursor_Info, 0x00008010
      .equ Set_Cursor_State, 0x00008011
      
  
      