
SetColor:
/* void SetColor (int red (r0), int green (r1), int blue (r2))
*/
   push {lr}
   mov r3,#BITS_PER_PIXEL     @Zunächst die eingestellte Farbtiefe holen
   cmp r3,#16                 @Farbtiefe = 16
   beq Bitmap16               @Dann Farbe für 16 Bit erstellen
   cmp r3,#32                 @Farbtiefe = 32
   beq Bitmap32               @Dann Farbe für 16 Bit erstellen
   pop {pc}

Bitmap16:
/* Im 16 Bit-Modus wird der Fabwert wie folgt abgelegt:
   5 Bits für rot, 6 Bits für grün, 5 Bits für blau
   Übergabe ist allerdings 8-Bits pro Farbe
*/
   lsr r0,#3                  @schiebe Bits um 3 nach rechte
   and r0,#0b00000000000000000000000000011111
                              @Und lösche höherwertige Bits
   lsl r0,#6                  @Schiebe Wert nach links, um platz für 
                              @nächsten Wert zu schafen
   lsr r1,#2                  @Schiebe Bits um 2 nach rechts
   and r1,#0b00000000000000000000000000111111
                              @Und lösche Höherwertige Bits
   orr r0,r1                  @Kopiere Wert nach r0
   lsl r0,#5                  @Und mache Platz
   lsr r2,#3                  @Schiebe Bits um 3 nach rechts
   and r2,#0b00000000000000000000000000011111
                              @Und lösche Höherwertige Bits
   orr r0,r2                  @Und kopiere Wert nach r0

   ldr r4,=Color              @Lade Adresse von "Color" nach r4
   str r0,[r4]                @Und speichere die Farbe dort ab
   pop {pc}

Bitmap32:
/* Im 32 Bit-Modus wird der Farbwert wie folgt abgelegt:
   8 Bits für Deckung, 8 Bits für rot, 8 Bits für grün, 8 Bits für blau
   Deckung wir immer als voll definiert
*/
   mov r3,#0xff      @Bestimmt die Deckung
   lsl r3,#8         @Mache Platz für nächsten Wert
   orr r3,r0         @Schreibe Rot-Anteil hinein
   lsl r3,#8         @Mache Platz für nächsten Wert
   orr r3,r1         @Schreibe Grün-Anteil hinein
   lsl r3,#8         @Mache Platz für nächsten Wert
   orr r3,r2         @Und schreibe Blau-Anteil hinein

   ldr r4,=Color     @Lade Adresse von "Color" nach r4
   str r3,[r4]       @Und speicher die Farbe dort ab.
   pop {pc}

.section .data
.align 1
Color:
   .int 0

.section .text

DrawPixel:
/* void DrawPixel (int x (r0), int y (r1))
*/
   push {r4,lr}

   @Zunächst überprüfen, ob Pixel in den Bildschirm passt
   mov r3,#SCREEN_X     @Lade Screen Breite nach r3
   sub r3,#1            @Subtrahiere es um eins
   cmp r0,r3            @Und Vergleiche es mit Übergabe
   pophi {r4,pc}           @Wenn es höher ist, dann zurück
   
   mov r3,#SCREEN_Y     @Lade Screen Höhe nach r3
   sub r3,#1            @Subtrahiere es um eins
   cmp r1,r3            @Und Vergleiche es mit der Übergabe
   pophi {r4,pc}           @Wenn es höher ist, dann zurück
   
   ldr r3,=graphicsAddress    @Lade Grafikadresse nach r3
   ldr r3,[r3]
   
   @Berechnung des Pixels im Screen
   
   mov r3,#SCREEN_X     @Screenbreite nach r3
   mla r3,r1,r3,r0      @Multipliziere mit y und addiere x

   ldr r4,=graphicsAddress    @Lade Grafikadresse nach r4
   ldr r4,[r4]

   mov r0,#BITS_PER_PIXEL     @Zunächst die eingestellte Farbtiefe holen
   cmp r0,#16                 @Farbtiefe = 16
   beq _Draw16               @Dann Farbe für 16 Bit erstellen
   cmp r0,#32                 @Farbtiefe = 32
   beq _Draw32               @Dann Farbe für 32 Bit erstellen
   pop {r4,pc}

_Draw16:
   add r4,r3,lsl #1  @Multipliziere r3 zunächst mit 2 und
                     @Addiere Ergebnis mit Grafikadresse
   ldr r2,=Color
   ldr r2,[r2]
   strh r2,[r4]       @Speichere die Farbe auf die berechnete Screenposition
   pop {r4,pc}
 
_Draw32:
   add r4,r3,lsl #2  @Multipliziere r3 zunächst mit 4 und
                     @Addiere Ergebnis mit Grafikadresse
   ldr r2,=Color
   ldr r2,[r2]
   str r2,[r4]       @Speichere die Farbe auf die berechnete Screenposition
   pop {r4,pc}

DrawLine:
	push {r4,r5,r6,r7,r8,r9,r10,r11,r12,lr}

	mov r9,r0         @r9 = x1
	mov r10,r2        @r10 = x2
	mov r11,r1        @r11 = y1
	mov r12,r3        @r12 = y2

	cmp r9,r10        @Vergleich x1 mit x2
                     @Wenn x1 größer als x2
	subgt r4,r9,r10      @DeltaX = x1 - x2
	movgt r6,#-1         @StepX = -1
                     @Ansonsten (x1 kleiner/gleich als x2)
	suble r4,r10,r9      @DeltaX = x2 - x1
	movle r6,#1          @StepX = 1
	
	cmp r11,r12       @Vergleich y1 mit y2
                     @Wenn y1 größer als x2
	subgt r5,r12,r11     @DeltaY = y1 - y2
	movgt r7,#-1         @StepY = -1
                     @Ansonsten (y1 kleiner/gleich als y2)
	suble r5,r11,r12     @DeltaY = y2 - y1
	movle r7,#1          @StepY = 1

	add r8,r4,r5      @Fehler = DeltaX + DeltaY 
	add r10,r6        @x2 = x2 + StepX
	add r12,r7        @y2 = y2 + StepY

	DrawLineLoop$:
		teq r9,r10     @Vergleiche x1 mit x2
		teqne r11,r12  @Wenn Ungleich; Vergleich y1 mit y2
		popeq {r4,r5,r6,r7,r8,r9,r10,r11,r12,pc} @Wenn gleich Ende

		mov r0,r9      @x1 nach r0
		mov r1,r11     @y1 nach r1
		bl DrawPixel   @Zeichne Punkt

		cmp r5, r8,lsl #1 @Wenn DeltaY kleiner/gleich Fehler * 2
		addle r8,r5          @Fehler = Fehler + DeltaY
		addle r9,r6          @x1 = x1 + StepX

		cmp r4, r8,lsl #1 @Wenn DeltaX größer Fehler * 2
		addge r8,r4          @Fehler = Fehler + DeltaX
		addge r11,r7         @y1 = y1 + StepY

		b DrawLineLoop$   @nächster Punkt

DrawFillBox:
/*
   void DrawFillBox (x0, y0, x1, y1)
*/
   push {r4,r5,r6,r7,lr}
   mov r4,r0         @r4 = x0
   mov r5,r1         @r5 = y0
   mov r6,r2         @r6 = x1
   mov r7,r3         @r7 = y1

DrawFillBoxLoop:
   mov r0,r4     
   mov r1,r5
   mov r2,r6
   mov r3,r5
   bl DrawLine
   add r5,#1
   cmp r5,r7
   ble DrawFillBoxLoop
   pop {r4,r5,r6,r7,pc}

