//
// base.h
//
// (C) by Satyria.de -> see https://satyria.de/arm/index.php?title=Graphics_in_C_(PI5)
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#ifndef _base_h
#define _base_h

#define RPI_BASE  0x107C000000UL

// GPIO
#define ARM_GPIO2_BASE RPI_BASE + 0x1517C00
#define ARM_GPIO2_DATA0 ARM_GPIO2_BASE + 0x04

//
// Mailbox
//
#define MAILBOX_BASE        RPI_BASE + 0x13880

#define MAILBOX0_READ       MAILBOX_BASE + 0x00
#define MAILBOX0_STATUS     MAILBOX_BASE + 0x18
#define MAILBOX_STATUS_EMPTY    0x40000000
#define MAILBOX1_WRITE      MAILBOX_BASE + 0x20
#define MAILBOX1_STATUS     MAILBOX_BASE + 0x38
#define MAILBOX_STATUS_FULL 0x80000000

#define MAILBOX_CHANNEL_PM  0       // power management
#define MAILBOX_CHANNEL_FB  1       // frame buffer
#define BCM_MAILBOX_PROP_OUT    8       // property tags (ARM to VC)

#endif