//
// led.c
//
// (C) by Satyria.de -> see https://satyria.de/arm/index.php?title=Graphics_in_C_(PI5)
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include "base.h"
#include "util.h"
#include "time.h"
#include "types.h"

void LED_off(void)
{
    u32 reg = read32(ARM_GPIO2_DATA0);
    reg &= ~0x200; // Bit 9 auf 0 setzen
    write32 (reg,ARM_GPIO2_DATA0);
}

void LED_on(void)
{
    u32 reg = read32 (ARM_GPIO2_DATA0);
    reg |= 0x200; // Bit 9 auf 1 setzen
    write32 (reg,ARM_GPIO2_DATA0);
}

void LED_Error(u32 errorcode) 
{
    while (TRUE) 
    {
        for (u32 z = 0; z < errorcode; z++) 
        {
            LED_on(); // LED einschalten
            wait(0x100000); // Warten
            LED_off(); // LED ausschalten
            wait(0x100000); // Warten
        }
        wait(0x100000); // Zusätzliche Wartezeit, um den Fehlercode erkennbar zu machen
    }
}
