// screen.c

// (C) by Satyria.de -> see https://satyria.de/arm/index.php?title=Graphics_in_C_(PI5)
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include "config.h"
#include "screen.h"
#include "mailbox.h"
#include "base.h"
#include "util.h"
#include "types.h"

u32 pScreen[8] ALIGN(16) = {
    8*4, //8 Einträge * 4 Bytes
    CODE_REQUEST,
    PROPTAG_ALLOCATE_BUFFER,
    8,
    4,
    0,  //m_nBufferPtr
    0,
    PROPTAG_END
};

u32 graphicsAddress = 0;
u32 DrawColor = 0xFFFFFFFF;

#define ADDRESS_MASK 0x3FFFFFFF

void Init_Screen(void) 
{

    uintptr pScreenAddress = (uintptr)pScreen;
    while (TRUE) {
        BcmMailBox_Write(BCM_MAILBOX_PROP_OUT,(u32)pScreenAddress);
        
        if (pScreen[5] != 0)
        {
            break;
        }
    }
    
    // Passt die Adresse an und speichert sie
    graphicsAddress = pScreen[5] & ADDRESS_MASK;
}

void DrawPixel(u32 x, u32 y)
{
    if ((x < SCREEN_X) && (y < SCREEN_Y))
    {
        write32(DrawColor,graphicsAddress+(((SCREEN_X*y)+x)*4));
    }
}
