//
// 29.07.2025 www.satyria.de
//
// config.h
//

#ifndef _config_h
#define _config_h

#define MEGABYTE          0x100000

#define MEM_KERNEL_START  0x80000          // Startadresse des Hauptprogramms
#define KERNEL_MAX_SIZE   (2 * MEGABYTE)
#define MEM_KERNEL_END    (MEM_KERNEL_START + KERNEL_MAX_SIZE)
#define KERNEL_STACK_SIZE 0x20000
#define CORES			4
#define MEM_KERNEL_STACK  (MEM_KERNEL_END + KERNEL_STACK_SIZE)

#define EXCEPTION_STACK_SIZE	0x8000
#define EXCEPTION_STACK	(MEM_KERNEL_STACK + KERNEL_STACK_SIZE * (CORES-1) + EXCEPTION_STACK_SIZE)

#define SCREEN_X       1920
#define SCREEN_Y       1080
#define BITS_PER_PIXEL 32

#endif