// mailbox.h

// (C) by Satyria.de -> see https://satyria.de/arm/index.php?title=Graphics_in_C_(PI5)
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#ifndef _ms_mailbox_h
#define _ms_mailbox_h

#include "types.h"


//Mailbox Tags
   //VideoCore
#define Get_firmware_revision  0x00000001
   //Hardware
#define Get_board_model  0x00010001
#define Get_board_revision  0x00010002
#define Get_board_MAC_address  0x00010003
#define Get_board_serial  0x00010004
#define Get_ARM_memory  0x00010005
#define Get_VC_memory  0x00010006
#define Get_clocks  0x00010007
   //Config
#define Get_command_line  0x00050001
   //Shared resource management
#define Get_DMA_channels  0x00060001
   //Power
#define Device_ID_SD_Card  0x00000000
#define Device_ID_UART0  0x00000001
#define Device_ID_UART1  0x00000002
#define Device_ID_USB_HCD  0x00000003
#define Device_ID_I2C0  0x00000004
#define Device_ID_I2C1  0x00000005
#define Device_ID_I2C2  0x00000006
#define Device_ID_SPI  0x00000007
#define Device_ID_CCP2TX  0x00000008
#define Device_ID_xyz1  0x00000009 //Unknown (RPi4)
#define Device_ID_xyz2  0x0000000a //Unknown (RPi4)
      
#define Get_power_state  0x00020001
#define Get_timing  0x00020002
#define Set_power_state  0x00028001
   //Clocks
#define Clock_ID_reserved  0x000000000
#define Clock_ID_EMMC  0x000000001
#define Clock_ID_UART  0x000000002
#define Clock_ID_ARM  0x000000003
#define Clock_ID_CORE  0x000000004
#define Clock_ID_V3D  0x000000005
#define Clock_ID_H264  0x000000006
#define Clock_ID_ISP  0x000000007
#define Clock_ID_SDRAM  0x000000008
#define Clock_ID_PIXEL  0x000000009
#define Clock_ID_PWM  0x00000000a
#define Clock_ID_HEVC  0x00000000b
#define Clock_ID_EMMC2  0x00000000c
#define Clock_ID_M2MC  0x00000000d
#define Clock_ID_PIXEL_BVB  0x00000000e

#define Get_clock_state  0x00030001
#define Set_clock_state  0x00038001
#define Get_clock_rate  0x00030002
#define Set_clock_rate  0x00038002
#define Get_max_clock_rate  0x00030004
#define Get_min_clock_rate  0x00030007
#define Get_turbo  0x00030009
#define Set_turbo  0x00038009
   //Voltage
#define Voltage_ID_reserved  0x000000000
#define Voltage_ID_Core  0x000000001
#define Voltage_ID_SDRAM_C  0x000000002
#define Voltage_ID_SDRAM_P  0x000000003
#define Voltage_ID_SDRAM_I  0x000000004

#define Get_voltage  0x00030003
#define Set_voltage  0x00038003
#define Get_max_voltage  0x00030005
#define Get_min_voltage  0x00030008
#define Get_temperature  0x00030006
#define Get_max_temperature  0x0003000a
#define Allocate_Memory  0x0003000c
#define Lock_memory  0x0003000d
#define Unlock_memory  0x0003000e
#define Release_Memory  0x0003000f
#define Execute_Code  0x00030010
#define Get_Dispmanx_Resource_mem_handle  0x00030014
#define Get_EDID_block  0x00030020
   //Frame Buffer
#define Allocate_buffer  0x00040001
#define Release_buffer  0x00048001
#define Blank_screen  0x00040002
#define Get_physical_display  0x00040003
#define Test_physical_display  0x00044003
#define Set_physical_display  0x00048003
#define Get_virtual_buffer  0x00040004
#define Test_virtual_buffer  0x00044004
#define Set_virtual_buffer  0x00048004
#define Get_depth  0x00040005
#define Test_depth  0x00044005
#define Set_depth  0x00048005
#define Get_pixel_order  0x00040006
#define Test_pixel_order  0x00044006
#define Set_pixel_order  0x00048006
#define Get_alpha_mode  0x00040007
#define Test_alpha_mode  0x00044007
#define Set_alpha_mode  0x00048007
#define Get_pitch  0x00040008
#define Get_virtual_offset  0x00040009
#define Test_virtual_offset  0x00044009
#define Set_virtual_offset  0x00048009
#define Get_overscan  0x0004000a
#define Test_overscan  0x0004400a
#define Set_overscan  0x0004800a
#define Get_palette  0x0004000b
#define Test_palette  0x0004400b
#define Set_palette  0x0004800b
#define Set_Cursor_Info  0x00008010
#define Set_Cursor_State  0x00008011


	#define CODE_REQUEST		0x00000000
	#define CODE_RESPONSE_SUCCESS	0x80000000
	#define CODE_RESPONSE_FAILURE	0x80000001

void BcmMailBox_Flush(void);
void BcmMailBox_Read(unsigned nChannel);
void BcmMailBox_Write(unsigned nChannel, u32 nData);
void BcmMailBox_WriteRead(unsigned nChannel, u32 nData);


#endif
