/*#include "types.h"
#include "kernel.h"*/
#include "base.h"
#include "time.h"
#include "util.h"
#include "printf.h"

void Interrupt_Initialize (void)
{
  write32(0,GICD_CTLR);

  // Enable interrupt 30 (falls < 32, dann ISENABLER0)
  write32 ((1 << TIMER_IRQ_ID),GICD_ISENABLER0);
  write32 (0xA0A0A0A0,GICD_IPRIORITYR7); // Priority
  write32 (0x01010101,GICD_ITARGETSR7); // CPU0

  write32(1,GICD_CTLR);
  write32(0xff,GICC_PMR);
  write32(1,GICC_CTLR);
}

void irq_dispatch(void)
{
  u32 irq = read32(GICC_IAR);
  if (irq == TIMER_IRQ_ID)
  {
    timer_irq_handler();
  }
  else
  {
    printf("Other IRQ: %d\n",irq);
  }
  write32(irq,GICC_EOIR);
}

void InitInterrupt(void)
{
  Interrupt_Initialize();
  InitCoreTimer();
  irq_enable();
}