//
// mailbox.c
//

#include "base.h"
#include "util.h"
#include "types.h"
#include "time.h"

static void BcmMailBox_Flush(void)
{
  while (!(read32(MAILBOX0_STATUS) & MAILBOX_STATUS_EMPTY))
  {
    read32(MAILBOX0_READ);
    wait(20);
  }
}

static void BcmMailBox_Read(unsigned nChannel)
{
  u32 nResult;

  do
  {
    while (read32(MAILBOX0_STATUS) & MAILBOX_STATUS_EMPTY)
    {
      // do nothing
    }
    nResult = read32(MAILBOX0_READ);
  } while ((nResult & 0xF) != nChannel);  // channel number is in the lower 4 bits
}

static void BcmMailBox_Write(unsigned nChannel, u32 nData)
{
  while (read32(MAILBOX1_STATUS) & MAILBOX_STATUS_FULL)
  {
    // do nothing
  }
  write32( nChannel | nData, MAILBOX1_WRITE);  // channel number is in the lower 4 bits
}

void BcmMailBox_WriteRead(unsigned nChannel, u32 nData)
{
  BcmMailBox_Flush();
  BcmMailBox_Write(nChannel, nData);
  BcmMailBox_Read(nChannel);
}
