//
// 29.07.2025 www.satyria.de
//
// time.c
//

#include "types.h"
#include "config.h"
#include "base.h"
#include "screen.h"
#include "util.h"

void wait(u32 zyklen) 
{
  volatile u32 i;
  for (i = 0; i < zyklen; i++) 
  {
    // Leere Schleife zur Verzögerung
  }
}

u32 Rotor = 0;
void timer_irq_handler(void) 
{
  if (Rotor == 0)
  {
    DrawChar('/', SCREEN_X-8, 0);
    Rotor++;
  }
  else if (Rotor == 1)
  {
    DrawChar('-', SCREEN_X-8, 0);
    Rotor++;
  }
  else if (Rotor == 2)
  {
    DrawChar('\\', SCREEN_X-8, 0);
    Rotor++;
  }
  else if (Rotor == 3)
  {
    DrawChar('|', SCREEN_X-8, 0);
    Rotor=0;
  }

  // Reset Timer
  unsigned long freq;
  asm volatile("mrs %0, cntfrq_el0" : "=r"(freq));
  asm volatile("msr cntp_tval_el0, %0" :: "r"(freq));
}

void InitCoreTimer(void)
{
  unsigned long freq;
  asm volatile("mrs %0, cntfrq_el0" : "=r"(freq));

  asm volatile ("msr cntp_tval_el0, %0" :: "r"(freq));  // 1 Sekunde
  asm volatile ("msr cntp_ctl_el0, %0" :: "r"(1));      // Timer aktivieren

  write32(2,TIMER_CNTRL0);
}