//
// VectorTable
// vector.S
//

.section .text

.align  11
.globl  VectorTable
VectorTable:
// Vektoren für EL1t (Current Exception Level SP_el0)
  .align  7
  b hang            // Synchronous Exception
  .align  7
  b IRQStub         // IRQ - Normal Interrupt
  .align  7
  b hang            // FIQ - Fast Interrupt
  .align  7
  b hang            // SError - System Error
// Vektoren für EL1h (Current Exception Level SP_el1)
  .align  7
  b hang            // Synchronous Exception
  .align  7
  b IRQStub         // IRQ - Normal Interrupt
  .align  7
  b hang            // FIQ - Fast Interrupt
  .align  7
  b hang            // SError - System Error
// Vektoren für EL0 64-bit Modus
  .align  7
  b hang            // Synchronous EL0 (64-bit)
  .align  7
  b hang            // IRQ EL0 (64-bit)
  .align  7
  b hang            // FIQ EL0 (64-bit)
  .align  7
  b hang            // Error EL0 (64-bit)
// Vektoren für EL0 32-bit Modus
  .align  7
  b hang            // Synchronous EL0 (32-bit)
  .align  7
  b hang            // IRQ EL0 (32-bit)
  .align  7
  b hang            // FIQ EL0 (32-bit)
  .align  7
  b hang            // Error EL0 (32-bit)

hang:
  wfe        // spare CPU cycles
  b hang

.globl IRQStub
IRQStub:
  stp x29, x30, [sp, #-16]!
  stp	x27, x28, [sp, #-16]!
  stp	x25, x26, [sp, #-16]!
  stp	x23, x24, [sp, #-16]!
  stp	x21, x22, [sp, #-16]!
  stp	x19, x20, [sp, #-16]!
  stp	x17, x18, [sp, #-16]!
  stp	x15, x16, [sp, #-16]!
  stp	x13, x14, [sp, #-16]!
  stp	x11, x12, [sp, #-16]!
  stp	x9, x10, [sp, #-16]!
  stp	x7, x8, [sp, #-16]!
  stp	x5, x6, [sp, #-16]!
  stp	x3, x4, [sp, #-16]!
  stp	x1, x2, [sp, #-16]!
  str	x0, [sp, #-16]!

    bl irq_dispatch  //Springe zur Auswertung

  ldr x0, [sp], #16
  ldp x1, x2, [sp], #16
  ldp x3, x4, [sp], #16
  ldp x5, x6, [sp], #16
  ldp x7, x8, [sp], #16
  ldp x9, x10, [sp], #16
  ldp x11, x12, [sp], #16
  ldp x13, x14, [sp], #16
  ldp x15, x16, [sp], #16
  ldp x17, x18, [sp], #16
  ldp x19, x20, [sp], #16
  ldp x21, x22, [sp], #16
  ldp x23, x24, [sp], #16
  ldp x25, x26, [sp], #16
  ldp x27, x28, [sp], #16
  ldp x29, x30, [sp], #16
  eret
  