//
// boot.S
//
// Copyright (C) 2025, Satyria.de
// More documentation available here: https://satyria.de/arm
//
// This program is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <https://www.gnu.org/licenses/>.
//

#include "config.h"

.section .init
.global _start

_start:

  mrs x1, mpidr_el1  //Lies den Inhalt des Systemregisters MPIDR_EL1 (Multiprocessor Affinity Register) und speichere ihn in Register x1.
  and x1, x1, #3
  cbz x1, core0
core_sleep: // Core 1-3 schlafen legen
  wfe
  b core_sleep
core0:	// Core 0 unsere HauptCPU
  // Wechsel nach EL1, mehr informationen unter https://www.satyria.de/arm

  mrs x0, CurrentEL   //Überprüfen, ob bereits in EL1
  cmp x0, #4
  beq switch_to_el1

  ldr x0, =EXCEPTION_STACK
  msr sp_el1, x0

  ldr x0, =VectorTable
  msr vbar_el2, x0

  mrs x0, cnthctl_el2
  orr x0, x0, #0x3
  msr cnthctl_el2, x0
  msr cntvoff_el2, xzr

  mrs x0, midr_el1
  mrs x1, mpidr_el1
  msr vpidr_el2, x0
  msr vmpidr_el2, x1

  mov x0, #0x33ff
  msr cptr_el2, x0
  msr hstr_el2, xzr

  mov x0, #3 << 20
  msr cpacr_el1, x0

  mov x0, #(1 << 31)
  msr hcr_el2, x0

  mov x0, #0x0800
  movk x0, #0x30d0, lsl #16
  msr sctlr_el1, x0

  mov x0, #0x3c4
  msr spsr_el2, x0
  adr x0, el1_return
  msr elr_el2, x0
  eret

el1_return:
switch_to_el1:
  ldr x1, =_start
  mov sp, x1          // Stack setzen

  ldr x0, =VectorTable
  msr vbar_el1, x0    // VectorTabelle setzen für Exceptions

  // BSS section reinigen
  ldr x1, =__bss_start
  ldr w2, =__bss_size
clean_bss_loop: 
  cbz w2, bss_clean_done    // Quit loop if zero
  str xzr, [x1], #8
  sub w2, w2, #1
  cbnz w2, clean_bss_loop   // Loop if non-zero

bss_clean_done:
  // Springe in unser Hauptprogramm
  b main