//
// exception.c
//
// Copyright (C) 2025, Satyria.de
// More documentation available here: https://satyria.de/arm
//
// This program is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <https://www.gnu.org/licenses/>.
//

#include "printf.h"
#include "sync.h"

void ExceptionHandler (int code)
{
  const char *Exmsg;
  switch (code)
  {
    case 0:
      Exmsg = "sync_exception";
      break;
    case 1:
      Exmsg = "serror_handler";
      break;
    case 2:
      Exmsg = "not used";
      break;
    case 3:
      Exmsg = "FastInterrupt (FIQ)";
      break;
    default:
      Exmsg = "Unbekannter Code\n";
      break;
  }
  printf ("Error: Exception '%s' ausgelöst\n", Exmsg);
  //Stop();	
}