//
// config.h
//
// Copyright (C) 2025, Satyria.de
// More documentation available here: https://satyria.de/arm
//
// This program is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <https://www.gnu.org/licenses/>.
//

#ifndef _config_h
#define _config_h

#define MEGABYTE	0x100000
#define GIGABYTE	0x40000000UL

#define KERNEL_START  0x80000          // Startadresse des Hauptprogramms
#define KERNEL_MAX_SIZE   (2 * MEGABYTE)
#define KERNEL_END    (KERNEL_START + KERNEL_MAX_SIZE)
#define KERNEL_STACK_SIZE 0x20000
#define CORES			4
#define KERNEL_STACK  (KERNEL_END + KERNEL_STACK_SIZE)

#define EXCEPTION_STACK_SIZE	0x8000
#define EXCEPTION_STACK	(KERNEL_STACK + KERNEL_STACK_SIZE * (CORES-1) + EXCEPTION_STACK_SIZE)
#define EXCEPTION_STACK_END	(EXCEPTION_STACK + EXCEPTION_STACK_SIZE * (CORES-1))

#define PAGE_RESERVE		(16 * MEGABYTE)
#define PAGE_SIZE		0x10000

#define COHERENT_REGION	((EXCEPTION_STACK_END + 2*MEGABYTE) & ~(MEGABYTE-1))

#define HEAP_START		(COHERENT_REGION + 4*MEGABYTE)
#define HEAP_END			(HEAP_START + 2*MEGABYTE)
#define MEMORY_START    HEAP_END
#define MAX_MEMORY		0xFFFFFFFFUL

#define SCREEN_X       1920
#define SCREEN_Y       1080
#define BITS_PER_PIXEL 32

#endif