//
// led.h
//
// Copyright (C) 2025, Satyria.de
// More documentation available here: https://satyria.de/arm
//
// This program is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <https://www.gnu.org/licenses/>.
//

#ifndef _ms_led_h
#define _ms_led_h

#include "types.h"

#define GPIO_input  0b000      //Input
#define GPIO_output 0b001      //Output
#define GPIO_alt0   0b100      //alternate function 0
#define GPIO_alt1   0b101      //alternate function 1
#define GPIO_alt2   0b110      //alternate function 2
#define GPIO_alt3   0b111      //alternate function 3
#define GPIO_alt4   0b011      //alternate function 4
#define GPIO_alt5   0b010      //alternate function 5

#define GPPUD_OFF    0b00

void LED_off(void);
void LED_on(void);
void SetGPIOFunction(u32 Pin, u32 Function);
void LED_Error(u32 errorcode);

#endif