//
// screen.h
//
// Copyright (C) 2025, Satyria.de
// More documentation available here: https://satyria.de/arm
//
// This program is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <https://www.gnu.org/licenses/>.
//

#ifndef _screen_h
#define _screen_h

#include "types.h"

void Init_Screen(void);
u32 GetGraphicsAddress(void);
void DrawPixel(u32 x, u32 y);
u32 GetPixel(u32 x, u32 y);
void SetDrawColor(u8 r, u8 g, u8 b);
void SetFrontColor(u8 r, u8 g, u8 b);
void SetBackColor(u8 r, u8 g, u8 b);
void DrawChar(char c, u32 x0, u32 y0);

void InitTerminal (void);
void ClearScreen();
void MoveCursor(u32 x, u32 y);
void ScrollScreen();
void DrawCharAtCursor(char c);
void DrawString(const char* str);
void putc(void* p, char c); //-> printf


#endif
