//
// interrupt.c
//
// Copyright (C) 2025, Satyria.de
// More documentation available here: https://satyria.de/arm
//
// This program is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <https://www.gnu.org/licenses/>.
//

#include "base.h"
#include "time.h"
#include "util.h"
#include "printf.h"

void Interrupt_Initialize (void)
{
  write32(0,GICD_CTLR);

  // Enable interrupt 30 (falls < 32, dann ISENABLER0)
  write32 ((1 << TIMER_IRQ_ID),GICD_ISENABLER0);
  write32 (0xA0A0A0A0,GICD_IPRIORITYR7); // Priority
  write32 (0x01010101,GICD_ITARGETSR7); // CPU0

  write32(1,GICD_CTLR);
  write32(0xff,GICC_PMR);
  write32(1,GICC_CTLR);
}

void irq_dispatch(void)
{
  u32 irq = read32(GICC_IAR);
  if (irq == TIMER_IRQ_ID)
  {
    timer_irq_handler();
  }
  else
  {
    printf("Other IRQ: %d\n",irq);
  }
  write32(irq,GICC_EOIR);
}

void InitInterrupt(void)
{
  Interrupt_Initialize();
  InitCoreTimer();
  irq_enable();
}