//
// kernel.c
//
// Copyright (C) 2025, Satyria.de
// More documentation available here: https://satyria.de/arm
//
// This program is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <https://www.gnu.org/licenses/>.
//

#include "led.h"
#include "screen.h"
#include "printf.h"
#include "util.h"
#include "interrupt.h"

int main (void)
{
  LED_off();
  Init_Screen();
  InitTerminal ();
  init_printf(0, putc);

  SetFrontColor(0x80, 0xa0, 0xff);
  printf("*****************************************************************************************\n");
  printf("***                                                                                   ***\n");
  printf("***                                (c) by Satyria                                     ***\n");
  printf("***                                                                                   ***\n");
  printf("*****************************************************************************************\n\n");
  SetFrontColor(0xff, 0xff, 0x00);

  InitInterrupt();
  LED_Error(2);
  return 0;	
}