//
// led.c
//
// Copyright (C) 2025, Satyria.de
// More documentation available here: https://satyria.de/arm
//
// This program is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <https://www.gnu.org/licenses/>.
//

#include "base.h"
#include "util.h"
#include "types.h"
#include "led.h"
#include "time.h"

void LED_on (void)
{
  u32 LED_Pin = 42;
  SetGPIOFunction(LED_Pin,GPIO_output);

  u32 GPSET = GPIO_GPSET0; 
  if (LED_Pin>31)
  {
    GPSET = GPSET + 4;
    LED_Pin = LED_Pin - 32;
  }
  write32(1<<LED_Pin,GPSET);
}

void LED_off (void)
{
  u32 LED_Pin = 42;
  SetGPIOFunction(LED_Pin,GPIO_output);

  u32 GPCLR = GPIO_GPCLR0; 
  if (LED_Pin>31)
  {
    GPCLR = GPCLR + 4;
    LED_Pin = LED_Pin - 32;
  }
  write32(1<<LED_Pin,GPCLR);
}

void SetGPIOFunction(u32 Pin, u32 Function)
{
  u32 GPSEL = GPIO_GPFSEL0;
  while (Pin >= 10)
  {
    Pin = Pin -10;
    GPSEL = GPSEL + 4;
  }
  Pin = Pin *3;
  Function = Function << Pin;
  u32 mask = 0b111 << Pin;
  mask =~mask; //Bitweise negieren

  u32 sel=read32(GPSEL);
  sel=sel&mask;
  sel=sel|Function;
  write32(sel,GPSEL);
}

void LED_Error(u32 errorcode) 
{
  while (TRUE) 
  {
    for (u32 z = 0; z < errorcode; z++) 
    {
      LED_on(); // LED einschalten
      wait(0x100000); // Kurze Wartezeit
      LED_off(); // LED ausschalten
      wait(0x100000); // Kurze Wartezeit
    }
    wait(0x100000); // Zusätzliche Wartezeit, um den Fehlercode erkennbar zu machen
  }
}
