//
// mailbox.c
//
// Copyright (C) 2025, Satyria.de
// More documentation available here: https://satyria.de/arm
//
// This program is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <https://www.gnu.org/licenses/>.
//

#include "base.h"
#include "util.h"
#include "types.h"
#include "time.h"

static void BcmMailBox_Flush(void)
{
  while (!(read32(MAILBOX0_STATUS) & MAILBOX_STATUS_EMPTY))
  {
    read32(MAILBOX0_READ);
    wait(20);
  }
}

static void BcmMailBox_Read(unsigned nChannel)
{
  u32 nResult;

  do
  {
    while (read32(MAILBOX0_STATUS) & MAILBOX_STATUS_EMPTY)
    {
      // do nothing
    }
    nResult = read32(MAILBOX0_READ);
  } while ((nResult & 0xF) != nChannel);  // channel number is in the lower 4 bits
}

static void BcmMailBox_Write(unsigned nChannel, u32 nData)
{
  while (read32(MAILBOX1_STATUS) & MAILBOX_STATUS_FULL)
  {
    // do nothing
  }
  write32( nChannel | nData, MAILBOX1_WRITE);  // channel number is in the lower 4 bits
}

void BcmMailBox_WriteRead(unsigned nChannel, u32 nData)
{
  BcmMailBox_Flush();
  BcmMailBox_Write(nChannel, nData);
  BcmMailBox_Read(nChannel);
}
