//
// time.c
//
// Copyright (C) 2025, Satyria.de
// More documentation available here: https://satyria.de/arm
//
// This program is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <https://www.gnu.org/licenses/>.
//

#include "types.h"
#include "config.h"
#include "base.h"
#include "screen.h"
#include "util.h"

void wait(u32 zyklen) 
{
  volatile u32 i;
  for (i = 0; i < zyklen; i++) 
  {
    // Leere Schleife zur Verzögerung
  }
}

u32 Rotor = 0;
void timer_irq_handler(void) 
{
  if (Rotor == 0)
  {
    DrawChar('/', SCREEN_X-8, 0);
    Rotor++;
  }
  else if (Rotor == 1)
  {
    DrawChar('-', SCREEN_X-8, 0);
    Rotor++;
  }
  else if (Rotor == 2)
  {
    DrawChar('\\', SCREEN_X-8, 0);
    Rotor++;
  }
  else if (Rotor == 3)
  {
    DrawChar('|', SCREEN_X-8, 0);
    Rotor=0;
  }

  // Reset Timer
  unsigned long freq;
  asm volatile("mrs %0, cntfrq_el0" : "=r"(freq));
  asm volatile("msr cntp_tval_el0, %0" :: "r"(freq));
}

void InitCoreTimer(void)
{
  unsigned long freq;
  asm volatile("mrs %0, cntfrq_el0" : "=r"(freq));

  asm volatile ("msr cntp_tval_el0, %0" :: "r"(freq));  // 1 Sekunde
  asm volatile ("msr cntp_ctl_el0, %0" :: "r"(1));      // Timer aktivieren

  write32(2,TIMER_CNTRL0);
}