//
// util.S
//
// Copyright (C) 2025, Satyria.de
// More documentation available here: https://satyria.de/arm
//
// This program is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <https://www.gnu.org/licenses/>.
//

.globl write32
write32:
  stp x29, x30, [sp, -16]!
  mov x29, sp
  str w0,[x1]
  ldp x29, x30, [sp], 16
  ret

.globl read32
read32:
  stp x29, x30, [sp, -16]!
  mov x29, sp
  ldr w0,[x0]
  ldp x29, x30, [sp], 16
  ret

.globl irq_enable
irq_enable:
  msr daifclr, #0xf
  ret

.globl irq_disable
irq_disable:
  msr daifset, #2
  ret

.globl irq_barrier
irq_barrier:
  dsb sy
  ret