//
// VectorTable
// vector.S
//
// Copyright (C) 2025, Satyria.de
// More documentation available here: https://satyria.de/arm
//
// This program is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <https://www.gnu.org/licenses/>.
//

.section .text

.align  11
.globl  VectorTable
VectorTable:
// Vektoren für EL1t (Current Exception Level SP_el0)
    .align	7
    b sync_exception          // Synchronous Exception
    .align	7
    b irq_handler             // IRQ - Normal Interrupt
    .align	7
    b fiq_handler            // FIQ - Fast Interrupt
    .align	7
    b serror_handler         // SError - System Error
// Vektoren für EL1h (Current Exception Level SP_el1)
    .align	7
    b sync_exception          // Synchronous Exception
    .align	7
    b irq_handler             // IRQ - Normal Interrupt
    .align	7
    b fiq_handler             // FIQ - Fast Interrupt
    .align	7
    b serror_handler          // SError - System Error
// Vektoren für EL0 64-bit Modus
    .align	7
    b hvc_handler             // Synchronous EL0 (64-bit), Hypervisor Call
    .align	7
    b not_used                // IRQ EL0 (64-bit)
    .align	7
    b not_used                // FIQ EL0 (64-bit)
    .align	7
    b not_used                // Error EL0 (64-bit)
// Vektoren für EL0 32-bit Modus
    .align	7
    b not_used                // Synchronous EL0 (32-bit)
    .align	7
    b not_used                // IRQ EL0 (32-bit)
    .align	7
    b not_used                // FIQ EL0 (32-bit)
    .align	7
    b not_used                // Error EL0 (32-bit)

sync_exception:
    mov x0,#0 //Fehlercode
    bl ExceptionHandler
	eret
serror_handler:
    mov x0,#1 //Fehlercode
    bl ExceptionHandler
	eret
not_used:
    mov x0,#2 //Fehlercode
    bl ExceptionHandler
	eret
fiq_handler:
    mov x0,#3 //Fehlercode
    bl ExceptionHandler
	eret

hvc_handler:					// Hypervisor Call, return to EL2h mode 
	mrs	x0, spsr_el2
	bic	x0, x0, #0xF
	mov	x1, #9
	orr	x0, x0, x1
	msr	spsr_el2, x0
	eret

.globl irq_handler
irq_handler:
	stp	x29, x30, [sp, #-16]!		//Zunächst x29, x30 sichern 

	mrs	x29, elr_el1			//Lies das Exception Link Register von EL1 
	mrs	x30, spsr_el1           //Lies das Saved Program Status Register von EL1
	stp	x29, x30, [sp, #-16]!   //Speichere `elr_el1` und `spsr_el1` auf dem Stack
	msr	DAIFClr, #1			    //Deaktiviere FIQ-Maskierung (ermögliche Fast Interrupts) 

	stp	q30, q31, [sp, #-32]!		// speichert q0-q31 auf den Stack 
	stp	q28, q29, [sp, #-32]!
	stp	q26, q27, [sp, #-32]!
	stp	q24, q25, [sp, #-32]!
	stp	q22, q23, [sp, #-32]!
	stp	q20, q21, [sp, #-32]!
	stp	q18, q19, [sp, #-32]!
	stp	q16, q17, [sp, #-32]!
	stp	q14, q15, [sp, #-32]!
	stp	q12, q13, [sp, #-32]!
	stp	q10, q11, [sp, #-32]!
	stp	q8, q9, [sp, #-32]!
	stp	q6, q7, [sp, #-32]!
	stp	q4, q5, [sp, #-32]!
	stp	q2, q3, [sp, #-32]!
	stp	q0, q1, [sp, #-32]!

	stp	x27, x28, [sp, #-16]!		// speichert x0-x28 auf den Stack 
	stp	x25, x26, [sp, #-16]!
	stp	x23, x24, [sp, #-16]!
	stp	x21, x22, [sp, #-16]!
	stp	x19, x20, [sp, #-16]!
	stp	x17, x18, [sp, #-16]!
	stp	x15, x16, [sp, #-16]!
	stp	x13, x14, [sp, #-16]!
	stp	x11, x12, [sp, #-16]!
	stp	x9, x10, [sp, #-16]!
	stp	x7, x8, [sp, #-16]!
	stp	x5, x6, [sp, #-16]!
	stp	x3, x4, [sp, #-16]!
	stp	x1, x2, [sp, #-16]!
	str	x0, [sp, #-16]!

	ldr	x0, =IRQReturnAddress		// store return address for profiling ??????????????????????????
	str	x29, [x0]

	bl	irq_dispatch          //Sprung in die Interruptroutine

	ldr	x0, [sp], #16			// Reaktivieren der Register x0-x28 vom Stack 
	ldp	x1, x2, [sp], #16
	ldp	x3, x4, [sp], #16
	ldp	x5, x6, [sp], #16
	ldp	x7, x8, [sp], #16
	ldp	x9, x10, [sp], #16
	ldp	x11, x12, [sp], #16
	ldp	x13, x14, [sp], #16
	ldp	x15, x16, [sp], #16
	ldp	x17, x18, [sp], #16
	ldp	x19, x20, [sp], #16
	ldp	x21, x22, [sp], #16
	ldp	x23, x24, [sp], #16
	ldp	x25, x26, [sp], #16
	ldp	x27, x28, [sp], #16

	ldp	q0, q1, [sp], #32		// Reaktivieren der Register q0-q31 vom Stack 
	ldp	q2, q3, [sp], #32
	ldp	q4, q5, [sp], #32
	ldp	q6, q7, [sp], #32
	ldp	q8, q9, [sp], #32
	ldp	q10, q11, [sp], #32
	ldp	q12, q13, [sp], #32
	ldp	q14, q15, [sp], #32
	ldp	q16, q17, [sp], #32
	ldp	q18, q19, [sp], #32
	ldp	q20, q21, [sp], #32
	ldp	q22, q23, [sp], #32
	ldp	q24, q25, [sp], #32
	ldp	q26, q27, [sp], #32
	ldp	q28, q29, [sp], #32
	ldp	q30, q31, [sp], #32

	msr	DAIFSet, #1			//Reaktiviere FIQ-Maskierung (sperre Fast Interrupts)
	ldp	x29, x30, [sp], #16		// Reaktivieren der Register elr_el1, spsr_el1 vom Stack 
	msr	elr_el1, x29
	msr	spsr_el1, x30

	ldp	x29, x30, [sp], #16		// Reaktivieren der Register x29, x30 vom Stack 

	eret                        //Zurück zum "normalen" Programmablauf

.data
.align	3

.globl	IRQReturnAddress
IRQReturnAddress:
	.quad	0
	.bss
.align	4
	.space	128
SMCStack: