//
// The Error program for RPI4
// 20.02.2025 www.satyria.de
//
// led.c
//

#include "base.h"
#include "util.h"
#include "types.h"
#include "led.h"
#include "time.h"

void LED_on (void)
{
  u32 LED_Pin = 42;
  SetGPIOFunction(LED_Pin,GPIO_output);

  u32 GPSET = GPIO_GPSET0; 
  if (LED_Pin>31)
  {
    GPSET = GPSET + 4;
    LED_Pin = LED_Pin - 32;
  }
  write32(GPSET,1<<LED_Pin);
}

void LED_off (void)
{
  u32 LED_Pin = 42;
  SetGPIOFunction(LED_Pin,GPIO_output);

  u32 GPCLR = GPIO_GPCLR0; 
  if (LED_Pin>31)
  {
    GPCLR = GPCLR + 4;
    LED_Pin = LED_Pin - 32;
  }
  write32(GPCLR,1<<LED_Pin);
}

void SetGPIOFunction(u32 Pin, u32 Function)
{
  u32 GPSEL = GPIO_GPFSEL0;
  while (Pin >= 10)
  {
    Pin = Pin -10;
    GPSEL = GPSEL + 4;
  }
  Pin = Pin *3;
  Function = Function << Pin;
  u32 mask = 0b111 << Pin;
  mask =~mask; //Bitweise negieren

  u32 sel=read32(GPSEL);
  sel=sel&mask;
  sel=sel|Function;
  write32(GPSEL,sel);
}

void LED_Error(u32 errorcode) 
{
    while (TRUE) 
    {
        for (u32 z = 0; z < errorcode; z++) 
        {
            LED_on(); // LED einschalten
            wait(0x100000); // Kurze Wartezeit
            LED_off(); // LED ausschalten
            wait(0x50000); // Kurze Wartezeit
        }
        wait(0x100000); // Zusätzliche Wartezeit, um den Fehlercode erkennbar zu machen
    }
}
