// screen.c

// (C) by Satyria.de -> see https://satyria.de/arm under Raspberry Pi4
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include "config.h"
#include "screen.h"
#include "mailbox.h"
#include "base.h"
#include "util.h"
#include "types.h"
//#include <stdint.h>
#include "led.h"

u32 pScreen[36] ALIGN(16) = {
    34*4, //34 Einträge * 4 Bytes
    0,
    Set_physical_display,
    0x8,0x8,
    SCREEN_X,
    SCREEN_Y,
    
    Set_virtual_buffer,
    0x8,0x8,
    SCREEN_X,
    SCREEN_Y,

    Set_depth,
    0x4,0x4,
    BITS_PER_PIXEL,
    
    Set_virtual_offset,
    0x8,0x8,
    0x0,0x0,
    
    Set_palette,
    0x10,0x10,
    0x0,
    0x2,
    0x00000000,
    0xffffffff,
    
    Allocate_buffer,
    0x8,0x8,
    0x0,
    0x0,

    0x00000000
};

u32 graphicsAddress = 0;
u32 DrawColor = 0xFFFFFFFF;
u32 FrontColor = 0xFFFFFFFF;
u32 BackColor = 0;

#define ADDRESS_MASK 0x3FFFFFFF

void Init_Screen(void) 
{

    uintptr pScreenAddress = (uintptr)pScreen;
    while (TRUE) {
        BcmMailBox_Write(BCM_MAILBOX_PROP_OUT,(u32)pScreenAddress);
        
        if (pScreen[31] != 0)
        {
            break;
        }
    }
    
    // Passt die Adresse an und speichert sie
    graphicsAddress = pScreen[31] & ADDRESS_MASK;
	 FrontColor = 0xFFFFFFFF;
	 BackColor = 0;
}

void DrawPixel(u32 x, u32 y)
{
    if ((x < SCREEN_X) && (y < SCREEN_Y))
    {
        write32(DrawColor,graphicsAddress+(((SCREEN_X*y)+x)*4));
    }
}