//
// led.S
//
// (C) by Satyria.de -> see https://satyria.de/arm/index.php?title=Making_the_LED_Blink_(PI5)
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
// 

#include "base.h"

// void LED_off(void) // Turns off the LED
.section .text
.globl LED_off
LED_off:
    ldr x1, =ARM_GPIO2_DATA0
    ldr w0, [x1]
    bic w0, w0, #0x200
    str w0, [x1]
    ret

// void LED_on(void) // Turns on the LED
.section .text
.globl LED_on
LED_on:
    ldr x1, =ARM_GPIO2_DATA0
    ldr w0, [x1]
    orr w0, w0, #0x200
    str w0, [x1]
    ret

.globl LED_Error      // In w0 = Error code
LED_Error:
    mov w10, w0       // Save w0 as the function "wait" uses w0 as a timer
1:
    mov w11, #0       // Set counter to NULL
2:
    cmp w11, w10      // Compare the values with the error code
    bhs 3f            // If greater, exit the inner loop

    bl LED_on         // Turn the LED on
    mov w0, 0x100000  // Wait for 0x100000 cycles
    bl wait

    bl LED_off        // Turn the LED off
    mov w0, 0x100000  // Wait again for 0x100000 cycles
    bl wait

    add w11, w11, 1   // Increment w11 by 1
    b 2b              // Repeat the loop
3:
    mov w0, 0x100000 // Wait an additional 0x100000 cycles to separate the code
    bl wait

    b 1b              // Repeat the code until we shut everything down