//
// screen.S
//
// (C) by Satyria.de -> see https://satyria.de/arm/index.php?title=Graphics_(PI5)
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include "config.h"
#include "base.h"
#include "mailbox.h"

.section .text

// boolean Init_Screen (void)
.globl Init_Screen
Init_Screen:
	stp x29, x30, [sp, -16]!
	mov x29, sp
1:
	ldr w0,=BCM_MAILBOX_PROP_OUT  // Channel
	ldr x1,=pScreen               // Screen structure
	bl BcmMailBox_Write           // Call the mailbox
    
    ldr x0,=m_nBufferPtr          // Load the memory address
    ldr w0,[x0]
    cmp w0,#0
    beq 1b
    and w0,w0,#0x3FFFFFFF         // Adjust the address
    ldr x1,=graphicsAddress       // And store it
    str w0,[x1]

    ldp x29, x30, [sp], 16
    ret

// void DrawPixel (x=w0, y=w1)
.globl DrawPixel
DrawPixel:
    stp x29, x30, [sp, -16]!
    stp x3, x4, [sp, -16]!
    mov x29, sp

    cmp w0, #SCREEN_X         // Check if the pixel fits on the screen
    bge 1f

    cmp w1, #SCREEN_Y
    bge 1f

    mov w3, SCREEN_X
    mul w3, w3, w1
    add w3, w3, w0

    lsl w3, w3, #2

    ldr x4, =graphicsAddress
    ldr w4, [x4]

    add w3, w3, w4
    ldr x2, =DrawColor
    ldr w2, [x2]
    str w2, [x3]
1:
    ldp x3, x4, [sp], 16
    ldp x29, x30, [sp], 16
    ret

//**********************************************************
// Data
//**********************************************************
.section .data
.align 16
pScreen:
		.int pScreen_end - pScreen
		.int CODE_REQUEST

		.int PROPTAG_ALLOCATE_BUFFER
		.int 8
		.int 4
m_nBufferPtr:
		.int 0
m_nBufferSize:
		.int 0
 
 .int PROPTAG_END	
pScreen_end:

.align 2
graphicsAddress:
	.int 0

DrawColor:
    .int 0xffffffff // for white
	 